%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      DefineSensor.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
%                 Professor Brian Wandell
%                 Professor Joyce Farrell
% Class:          PSYCH221
% File Version:   1
% Description:    This file defines the sensor
%-------------------------------------------------------------------------------


% THIS SCRIPT IS OPTIONAL... PROBABLY


% To get the pixel structure from the sensor we use:
pixel =  sensorGet(sensor,'pixel');

% We set these properties here
pixel = pixelSet(pixel,'size',[pixelSize pixelSize]);   
pixel = pixelSet(pixel,'conversiongain', conversiongain);        
pixel = pixelSet(pixel,'voltageswing',voltageSwing);                                             
pixel = pixelSet(pixel,'darkvoltage',darkvoltage) ;               
pixel = pixelSet(pixel,'readnoisevolts',readnoise);  

% Set these sensor properties
sensor = sensorSet(sensor,'exposuretime',exposureDuration); 
%sensor = sensorSet(sensor,'rows',rows);
%sensor = sensorSet(sensor,'cols',cols);
sensor = sensorSet(sensor,'dsnulevel',dsnu);  
sensor = sensorSet(sensor,'prnulevel',prnu); 
sensor = sensorSet(sensor,'analogGain',analogGain);     
sensor = sensorSet(sensor,'analogOffset',analogOffset);   


% Stuff the pixel back into the sensor structure
sensor = sensorSet(sensor,'pixel',pixel);
sensor = pixelCenterFillPD(sensor,fillfactor);

% We are now ready to compute the sensor image
sensor = sensorCompute(sensor,oi);

vcAddAndSelectObject('sensor',sensor);
if showISET == TRUE,
   sensorImageWindow;
end


%{
% Get the sensor values in volts
SensorVolts = sensorGet(sensor,'volts');

% Get the sensor values in digital units
% Note: We first need to specify that we want digital output, and
% select the bit depth
sensor.quantization.method = 'linear';
sensor.quantization.bits = 12;

% Run the sensor computation
sensor = sensorCompute(sensor,oi);

% Get the digital data
SensorDigital = sensorGet(sensor,'digitalvalues');
%}

% End of File
